package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.LockToken
import scala.jdk.CollectionConverters._
final case class DeleteFirewallManagerRuleGroupsResponse(
    nextWebACLLockToken: Option[LockToken] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse = {
    import DeleteFirewallManagerRuleGroupsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse
      .builder()
      .optionallyWith(
        nextWebACLLockToken.map(value =>
          LockToken.unwrap(value): java.lang.String
        )
      )(_.nextWebACLLockToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly =
    zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse
      .wrap(buildAwsValue())
}
object DeleteFirewallManagerRuleGroupsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse =
      zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse(
        nextWebACLLockToken.map(value => value)
      )
    def nextWebACLLockToken: Option[LockToken]
    def getNextWebACLLockToken: ZIO[Any, AwsError, LockToken] =
      AwsError.unwrapOptionField("nextWebACLLockToken", nextWebACLLockToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse
  ) extends zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly {
    override val nextWebACLLockToken: Option[LockToken] = scala
      .Option(impl.nextWebACLLockToken())
      .map(value => zio.aws.wafv2.model.primitives.LockToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.DeleteFirewallManagerRuleGroupsResponse
  ): zio.aws.wafv2.model.DeleteFirewallManagerRuleGroupsResponse.ReadOnly =
    new Wrapper(impl)
}
