package zio.aws.wafv2.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{IPAddress, EntityDescription, EntityName}
import scala.jdk.CollectionConverters._
final case class CreateIpSetRequest(
    name: EntityName,
    scope: zio.aws.wafv2.model.Scope,
    description: Option[EntityDescription] = None,
    ipAddressVersion: zio.aws.wafv2.model.IPAddressVersion,
    addresses: Iterable[IPAddress],
    tags: Option[Iterable[zio.aws.wafv2.model.Tag]] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest = {
    import CreateIpSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest
      .builder()
      .name(EntityName.unwrap(name): java.lang.String)
      .scope(scope.unwrap)
      .optionallyWith(
        description.map(value =>
          EntityDescription.unwrap(value): java.lang.String
        )
      )(_.description)
      .ipAddressVersion(ipAddressVersion.unwrap)
      .addresses(addresses.map { item =>
        IPAddress.unwrap(item): java.lang.String
      }.asJavaCollection)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CreateIpSetRequest.ReadOnly =
    zio.aws.wafv2.model.CreateIpSetRequest.wrap(buildAwsValue())
}
object CreateIpSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CreateIpSetRequest =
      zio.aws.wafv2.model.CreateIpSetRequest(
        name,
        scope,
        description.map(value => value),
        ipAddressVersion,
        addresses,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: EntityName
    def scope: zio.aws.wafv2.model.Scope
    def description: Option[EntityDescription]
    def ipAddressVersion: zio.aws.wafv2.model.IPAddressVersion
    def addresses: List[IPAddress]
    def tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, EntityName] = ZIO.succeed(name)
    def getScope: ZIO[Any, Nothing, zio.aws.wafv2.model.Scope] =
      ZIO.succeed(scope)
    def getDescription: ZIO[Any, AwsError, EntityDescription] =
      AwsError.unwrapOptionField("description", description)
    def getIpAddressVersion
        : ZIO[Any, Nothing, zio.aws.wafv2.model.IPAddressVersion] =
      ZIO.succeed(ipAddressVersion)
    def getAddresses: ZIO[Any, Nothing, List[IPAddress]] =
      ZIO.succeed(addresses)
    def getTags: ZIO[Any, AwsError, List[zio.aws.wafv2.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest
  ) extends zio.aws.wafv2.model.CreateIpSetRequest.ReadOnly {
    override val name: EntityName =
      zio.aws.wafv2.model.primitives.EntityName(impl.name())
    override val scope: zio.aws.wafv2.model.Scope =
      zio.aws.wafv2.model.Scope.wrap(impl.scope())
    override val description: Option[EntityDescription] = scala
      .Option(impl.description())
      .map(value => zio.aws.wafv2.model.primitives.EntityDescription(value))
    override val ipAddressVersion: zio.aws.wafv2.model.IPAddressVersion =
      zio.aws.wafv2.model.IPAddressVersion.wrap(impl.ipAddressVersion())
    override val addresses: List[IPAddress] = impl
      .addresses()
      .asScala
      .map { item =>
        zio.aws.wafv2.model.primitives.IPAddress(item)
      }
      .toList
    override val tags: Option[List[zio.aws.wafv2.model.Tag.ReadOnly]] = scala
      .Option(impl.tags())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafv2.model.Tag.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CreateIpSetRequest
  ): zio.aws.wafv2.model.CreateIpSetRequest.ReadOnly = new Wrapper(impl)
}
