package zio.aws.wafv2.model
import java.lang.Integer
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.aws.wafv2.model.primitives.{SolveTimestamp, ResponseCode}
import scala.jdk.CollectionConverters._
final case class CaptchaResponse(
    responseCode: Option[ResponseCode] = None,
    solveTimestamp: Option[SolveTimestamp] = None,
    failureReason: Option[zio.aws.wafv2.model.FailureReason] = None
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.wafv2.model.CaptchaResponse = {
    import CaptchaResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.wafv2.model.CaptchaResponse
      .builder()
      .optionallyWith(
        responseCode.map(value => ResponseCode.unwrap(value): Integer)
      )(_.responseCode)
      .optionallyWith(
        solveTimestamp.map(value =>
          SolveTimestamp.unwrap(value): java.lang.Long
        )
      )(_.solveTimestamp)
      .optionallyWith(failureReason.map(value => value.unwrap))(_.failureReason)
      .build()
  }
  def asReadOnly: zio.aws.wafv2.model.CaptchaResponse.ReadOnly =
    zio.aws.wafv2.model.CaptchaResponse.wrap(buildAwsValue())
}
object CaptchaResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.wafv2.model.CaptchaResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafv2.model.CaptchaResponse =
      zio.aws.wafv2.model.CaptchaResponse(
        responseCode.map(value => value),
        solveTimestamp.map(value => value),
        failureReason.map(value => value)
      )
    def responseCode: Option[ResponseCode]
    def solveTimestamp: Option[SolveTimestamp]
    def failureReason: Option[zio.aws.wafv2.model.FailureReason]
    def getResponseCode: ZIO[Any, AwsError, ResponseCode] =
      AwsError.unwrapOptionField("responseCode", responseCode)
    def getSolveTimestamp: ZIO[Any, AwsError, SolveTimestamp] =
      AwsError.unwrapOptionField("solveTimestamp", solveTimestamp)
    def getFailureReason
        : ZIO[Any, AwsError, zio.aws.wafv2.model.FailureReason] =
      AwsError.unwrapOptionField("failureReason", failureReason)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.wafv2.model.CaptchaResponse
  ) extends zio.aws.wafv2.model.CaptchaResponse.ReadOnly {
    override val responseCode: Option[ResponseCode] = scala
      .Option(impl.responseCode())
      .map(value => zio.aws.wafv2.model.primitives.ResponseCode(value))
    override val solveTimestamp: Option[SolveTimestamp] = scala
      .Option(impl.solveTimestamp())
      .map(value => zio.aws.wafv2.model.primitives.SolveTimestamp(value))
    override val failureReason: Option[zio.aws.wafv2.model.FailureReason] =
      scala
        .Option(impl.failureReason())
        .map(value => zio.aws.wafv2.model.FailureReason.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.wafv2.model.CaptchaResponse
  ): zio.aws.wafv2.model.CaptchaResponse.ReadOnly = new Wrapper(impl)
}
