package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRegexMatchSetRequest(
    regexMatchSetId: ResourceId,
    updates: Iterable[zio.aws.wafregional.model.RegexMatchSetUpdate],
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest = {
    import UpdateRegexMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
      .builder()
      .regexMatchSetId(ResourceId.unwrap(regexMatchSetId): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.UpdateRegexMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.UpdateRegexMatchSetRequest.wrap(buildAwsValue())
}
object UpdateRegexMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UpdateRegexMatchSetRequest =
      zio.aws.wafregional.model.UpdateRegexMatchSetRequest(
        regexMatchSetId,
        updates.map { item =>
          item.asEditable
        },
        changeToken
      )
    def regexMatchSetId: ResourceId
    def updates: List[zio.aws.wafregional.model.RegexMatchSetUpdate.ReadOnly]
    def changeToken: ChangeToken
    def getRegexMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexMatchSetId)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.RegexMatchSetUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
  ) extends zio.aws.wafregional.model.UpdateRegexMatchSetRequest.ReadOnly {
    override val regexMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexMatchSetId())
    override val updates
        : List[zio.aws.wafregional.model.RegexMatchSetUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.RegexMatchSetUpdate.wrap(item)
      }
      .toList
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRegexMatchSetRequest
  ): zio.aws.wafregional.model.UpdateRegexMatchSetRequest.ReadOnly =
    new Wrapper(impl)
}
