package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListRegexMatchSetsResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    regexMatchSets: Optional[
      Iterable[zio.aws.wafregional.model.RegexMatchSetSummary]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListRegexMatchSetsResponse = {
    import ListRegexMatchSetsResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListRegexMatchSetsResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        regexMatchSets.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.regexMatchSets)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListRegexMatchSetsResponse.ReadOnly =
    zio.aws.wafregional.model.ListRegexMatchSetsResponse.wrap(buildAwsValue())
}
object ListRegexMatchSetsResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListRegexMatchSetsResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ListRegexMatchSetsResponse =
      zio.aws.wafregional.model.ListRegexMatchSetsResponse(
        nextMarker.map(value => value),
        regexMatchSets.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def regexMatchSets: Optional[
      List[zio.aws.wafregional.model.RegexMatchSetSummary.ReadOnly]
    ]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getRegexMatchSets: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.RegexMatchSetSummary.ReadOnly
    ]] = AwsError.unwrapOptionField("regexMatchSets", regexMatchSets)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListRegexMatchSetsResponse
  ) extends zio.aws.wafregional.model.ListRegexMatchSetsResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val regexMatchSets: Optional[
      List[zio.aws.wafregional.model.RegexMatchSetSummary.ReadOnly]
    ] = zio.aws.core.internal
      .optionalFromNullable(impl.regexMatchSets())
      .map(value =>
        value.asScala.map { item =>
          zio.aws.wafregional.model.RegexMatchSetSummary.wrap(item)
        }.toList
      )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListRegexMatchSetsResponse
  ): zio.aws.wafregional.model.ListRegexMatchSetsResponse.ReadOnly =
    new Wrapper(impl)
}
