package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteRuleRequest(
    ruleId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRuleRequest = {
    import DeleteRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRuleRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteRuleRequest.ReadOnly =
    zio.aws.wafregional.model.DeleteRuleRequest.wrap(buildAwsValue())
}
object DeleteRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteRuleRequest =
      zio.aws.wafregional.model.DeleteRuleRequest(ruleId, changeToken)
    def ruleId: ResourceId
    def changeToken: ChangeToken
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleRequest
  ) extends zio.aws.wafregional.model.DeleteRuleRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleRequest
  ): zio.aws.wafregional.model.DeleteRuleRequest.ReadOnly = new Wrapper(impl)
}
