package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{PolicyString, ResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class PutPermissionPolicyRequest(
    resourceArn: ResourceArn,
    policy: PolicyString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.PutPermissionPolicyRequest = {
    import PutPermissionPolicyRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.PutPermissionPolicyRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .policy(PolicyString.unwrap(policy): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.PutPermissionPolicyRequest.ReadOnly =
    zio.aws.wafregional.model.PutPermissionPolicyRequest.wrap(buildAwsValue())
}
object PutPermissionPolicyRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.PutPermissionPolicyRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.PutPermissionPolicyRequest =
      zio.aws.wafregional.model.PutPermissionPolicyRequest(resourceArn, policy)
    def resourceArn: ResourceArn
    def policy: PolicyString
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
    def getPolicy: ZIO[Any, Nothing, PolicyString] = ZIO.succeed(policy)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.PutPermissionPolicyRequest
  ) extends zio.aws.wafregional.model.PutPermissionPolicyRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceArn())
    override val policy: PolicyString =
      zio.aws.wafregional.model.primitives.PolicyString(impl.policy())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.PutPermissionPolicyRequest
  ): zio.aws.wafregional.model.PutPermissionPolicyRequest.ReadOnly =
    new Wrapper(impl)
}
