package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class UpdateSqlInjectionMatchSetResponse(
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse = {
    import UpdateSqlInjectionMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.UpdateSqlInjectionMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.UpdateSqlInjectionMatchSetResponse
      .wrap(buildAwsValue())
}
object UpdateSqlInjectionMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.UpdateSqlInjectionMatchSetResponse =
      zio.aws.wafregional.model
        .UpdateSqlInjectionMatchSetResponse(changeToken.map(value => value))
    def changeToken: Optional[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
  ) extends zio.aws.wafregional.model.UpdateSqlInjectionMatchSetResponse.ReadOnly {
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateSqlInjectionMatchSetResponse
  ): zio.aws.wafregional.model.UpdateSqlInjectionMatchSetResponse.ReadOnly =
    new Wrapper(impl)
}
