package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRuleGroupRequest(
    ruleGroupId: ResourceId,
    updates: Iterable[zio.aws.wafregional.model.RuleGroupUpdate],
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest = {
    import UpdateRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.UpdateRuleGroupRequest.ReadOnly =
    zio.aws.wafregional.model.UpdateRuleGroupRequest.wrap(buildAwsValue())
}
object UpdateRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UpdateRuleGroupRequest =
      zio.aws.wafregional.model.UpdateRuleGroupRequest(
        ruleGroupId,
        updates.map { item =>
          item.asEditable
        },
        changeToken
      )
    def ruleGroupId: ResourceId
    def updates: List[zio.aws.wafregional.model.RuleGroupUpdate.ReadOnly]
    def changeToken: ChangeToken
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.RuleGroupUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
  ) extends zio.aws.wafregional.model.UpdateRuleGroupRequest.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleGroupId())
    override val updates
        : List[zio.aws.wafregional.model.RuleGroupUpdate.ReadOnly] = impl
      .updates()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.RuleGroupUpdate.wrap(item)
      }
      .toList
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRuleGroupRequest
  ): zio.aws.wafregional.model.UpdateRuleGroupRequest.ReadOnly = new Wrapper(
    impl
  )
}
