package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class IPSetUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    ipSetDescriptor: zio.aws.wafregional.model.IPSetDescriptor
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.IPSetUpdate = {
    import IPSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.IPSetUpdate
      .builder()
      .action(action.unwrap)
      .ipSetDescriptor(ipSetDescriptor.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.IPSetUpdate.ReadOnly =
    zio.aws.wafregional.model.IPSetUpdate.wrap(buildAwsValue())
}
object IPSetUpdate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.IPSetUpdate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.IPSetUpdate =
      zio.aws.wafregional.model.IPSetUpdate(action, ipSetDescriptor.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def ipSetDescriptor: zio.aws.wafregional.model.IPSetDescriptor.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getIpSetDescriptor: ZIO[
      Any,
      Nothing,
      zio.aws.wafregional.model.IPSetDescriptor.ReadOnly
    ] = ZIO.succeed(ipSetDescriptor)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.IPSetUpdate
  ) extends zio.aws.wafregional.model.IPSetUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val ipSetDescriptor
        : zio.aws.wafregional.model.IPSetDescriptor.ReadOnly =
      zio.aws.wafregional.model.IPSetDescriptor.wrap(impl.ipSetDescriptor())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.IPSetUpdate
  ): zio.aws.wafregional.model.IPSetUpdate.ReadOnly = new Wrapper(impl)
}
