package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{TagKey, ResourceArn}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UntagResourceRequest(
    resourceARN: ResourceArn,
    tagKeys: Iterable[TagKey]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UntagResourceRequest = {
    import UntagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UntagResourceRequest
      .builder()
      .resourceARN(ResourceArn.unwrap(resourceARN): java.lang.String)
      .tagKeys(tagKeys.map { item =>
        TagKey.unwrap(item): java.lang.String
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.UntagResourceRequest.ReadOnly =
    zio.aws.wafregional.model.UntagResourceRequest.wrap(buildAwsValue())
}
object UntagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UntagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UntagResourceRequest =
      zio.aws.wafregional.model.UntagResourceRequest(resourceARN, tagKeys)
    def resourceARN: ResourceArn
    def tagKeys: List[TagKey]
    def getResourceARN: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceARN)
    def getTagKeys: ZIO[Any, Nothing, List[TagKey]] = ZIO.succeed(tagKeys)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UntagResourceRequest
  ) extends zio.aws.wafregional.model.UntagResourceRequest.ReadOnly {
    override val resourceARN: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceARN())
    override val tagKeys: List[TagKey] = impl
      .tagKeys()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.primitives.TagKey(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UntagResourceRequest
  ): zio.aws.wafregional.model.UntagResourceRequest.ReadOnly = new Wrapper(impl)
}
