package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class TagResourceRequest(
    resourceARN: ResourceArn,
    tags: Iterable[zio.aws.wafregional.model.Tag]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.TagResourceRequest = {
    import TagResourceRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.TagResourceRequest
      .builder()
      .resourceARN(ResourceArn.unwrap(resourceARN): java.lang.String)
      .tags(tags.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.TagResourceRequest.ReadOnly =
    zio.aws.wafregional.model.TagResourceRequest.wrap(buildAwsValue())
}
object TagResourceRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.TagResourceRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.TagResourceRequest =
      zio.aws.wafregional.model.TagResourceRequest(
        resourceARN,
        tags.map { item =>
          item.asEditable
        }
      )
    def resourceARN: ResourceArn
    def tags: List[zio.aws.wafregional.model.Tag.ReadOnly]
    def getResourceARN: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceARN)
    def getTags
        : ZIO[Any, Nothing, List[zio.aws.wafregional.model.Tag.ReadOnly]] =
      ZIO.succeed(tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.TagResourceRequest
  ) extends zio.aws.wafregional.model.TagResourceRequest.ReadOnly {
    override val resourceARN: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceARN())
    override val tags: List[zio.aws.wafregional.model.Tag.ReadOnly] = impl
      .tags()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.Tag.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.TagResourceRequest
  ): zio.aws.wafregional.model.TagResourceRequest.ReadOnly = new Wrapper(impl)
}
