package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.NextMarker
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class ListActivatedRulesInRuleGroupResponse(
    nextMarker: Optional[NextMarker] = Optional.Absent,
    activatedRules: Optional[
      Iterable[zio.aws.wafregional.model.ActivatedRule]
    ] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse = {
    import ListActivatedRulesInRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
      .builder()
      .optionallyWith(
        nextMarker.map(value => NextMarker.unwrap(value): java.lang.String)
      )(_.nextMarker)
      .optionallyWith(
        activatedRules.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.activatedRules)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse.ReadOnly =
    zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse
      .wrap(buildAwsValue())
}
object ListActivatedRulesInRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable
        : zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse =
      zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse(
        nextMarker.map(value => value),
        activatedRules.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def nextMarker: Optional[NextMarker]
    def activatedRules
        : Optional[List[zio.aws.wafregional.model.ActivatedRule.ReadOnly]]
    def getNextMarker: ZIO[Any, AwsError, NextMarker] =
      AwsError.unwrapOptionField("nextMarker", nextMarker)
    def getActivatedRules: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.ActivatedRule.ReadOnly
    ]] = AwsError.unwrapOptionField("activatedRules", activatedRules)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
  ) extends zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse.ReadOnly {
    override val nextMarker: Optional[NextMarker] = zio.aws.core.internal
      .optionalFromNullable(impl.nextMarker())
      .map(value => zio.aws.wafregional.model.primitives.NextMarker(value))
    override val activatedRules
        : Optional[List[zio.aws.wafregional.model.ActivatedRule.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.activatedRules())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafregional.model.ActivatedRule.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ListActivatedRulesInRuleGroupResponse
  ): zio.aws.wafregional.model.ListActivatedRulesInRuleGroupResponse.ReadOnly =
    new Wrapper(impl)
}
