package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRateBasedRuleRequest(ruleId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest = {
    import GetRateBasedRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetRateBasedRuleRequest.ReadOnly =
    zio.aws.wafregional.model.GetRateBasedRuleRequest.wrap(buildAwsValue())
}
object GetRateBasedRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRateBasedRuleRequest =
      zio.aws.wafregional.model.GetRateBasedRuleRequest(ruleId)
    def ruleId: ResourceId
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
  ) extends zio.aws.wafregional.model.GetRateBasedRuleRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleRequest
  ): zio.aws.wafregional.model.GetRateBasedRuleRequest.ReadOnly = new Wrapper(
    impl
  )
}
