package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetGeoMatchSetRequest(geoMatchSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest = {
    import GetGeoMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetGeoMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.GetGeoMatchSetRequest.wrap(buildAwsValue())
}
object GetGeoMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetGeoMatchSetRequest =
      zio.aws.wafregional.model.GetGeoMatchSetRequest(geoMatchSetId)
    def geoMatchSetId: ResourceId
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
  ) extends zio.aws.wafregional.model.GetGeoMatchSetRequest.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.geoMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetGeoMatchSetRequest
  ): zio.aws.wafregional.model.GetGeoMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
