package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceArn
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DisassociateWebAclRequest(resourceArn: ResourceArn) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DisassociateWebAclRequest = {
    import DisassociateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DisassociateWebAclRequest
      .builder()
      .resourceArn(ResourceArn.unwrap(resourceArn): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DisassociateWebAclRequest.ReadOnly =
    zio.aws.wafregional.model.DisassociateWebAclRequest.wrap(buildAwsValue())
}
object DisassociateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DisassociateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DisassociateWebAclRequest =
      zio.aws.wafregional.model.DisassociateWebAclRequest(resourceArn)
    def resourceArn: ResourceArn
    def getResourceArn: ZIO[Any, Nothing, ResourceArn] =
      ZIO.succeed(resourceArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DisassociateWebAclRequest
  ) extends zio.aws.wafregional.model.DisassociateWebAclRequest.ReadOnly {
    override val resourceArn: ResourceArn =
      zio.aws.wafregional.model.primitives.ResourceArn(impl.resourceArn())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DisassociateWebAclRequest
  ): zio.aws.wafregional.model.DisassociateWebAclRequest.ReadOnly = new Wrapper(
    impl
  )
}
