package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class XssMatchSetSummary(
    xssMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.XssMatchSetSummary = {
    import XssMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchSetSummary
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.XssMatchSetSummary.ReadOnly =
    zio.aws.wafregional.model.XssMatchSetSummary.wrap(buildAwsValue())
}
object XssMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.XssMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.XssMatchSetSummary =
      zio.aws.wafregional.model.XssMatchSetSummary(xssMatchSetId, name)
    def xssMatchSetId: ResourceId
    def name: ResourceName
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetSummary
  ) extends zio.aws.wafregional.model.XssMatchSetSummary.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.xssMatchSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetSummary
  ): zio.aws.wafregional.model.XssMatchSetSummary.ReadOnly = new Wrapper(impl)
}
