package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class WebACLUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    activatedRule: zio.aws.wafregional.model.ActivatedRule
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.WebACLUpdate = {
    import WebACLUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.WebACLUpdate
      .builder()
      .action(action.unwrap)
      .activatedRule(activatedRule.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.WebACLUpdate.ReadOnly =
    zio.aws.wafregional.model.WebACLUpdate.wrap(buildAwsValue())
}
object WebACLUpdate {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.WebACLUpdate] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.WebACLUpdate =
      zio.aws.wafregional.model.WebACLUpdate(action, activatedRule.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def activatedRule: zio.aws.wafregional.model.ActivatedRule.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getActivatedRule
        : ZIO[Any, Nothing, zio.aws.wafregional.model.ActivatedRule.ReadOnly] =
      ZIO.succeed(activatedRule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.WebACLUpdate
  ) extends zio.aws.wafregional.model.WebACLUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val activatedRule
        : zio.aws.wafregional.model.ActivatedRule.ReadOnly =
      zio.aws.wafregional.model.ActivatedRule.wrap(impl.activatedRule())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.WebACLUpdate
  ): zio.aws.wafregional.model.WebACLUpdate.ReadOnly = new Wrapper(impl)
}
