package zio.aws.wafregional.model
import scala.jdk.CollectionConverters.*
sealed trait ResourceType {
  def unwrap: software.amazon.awssdk.services.waf.model.ResourceType
}
object ResourceType {
  def wrap(
      value: software.amazon.awssdk.services.waf.model.ResourceType
  ): zio.aws.wafregional.model.ResourceType = value match {
    case software.amazon.awssdk.services.waf.model.ResourceType.UNKNOWN_TO_SDK_VERSION =>
      val r = unknownToSdkVersion
      r
    case software.amazon.awssdk.services.waf.model.ResourceType.APPLICATION_LOAD_BALANCER =>
      val r = APPLICATION_LOAD_BALANCER
      r
    case software.amazon.awssdk.services.waf.model.ResourceType.API_GATEWAY =>
      val r = API_GATEWAY
      r
  }
  case object unknownToSdkVersion
      extends zio.aws.wafregional.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ResourceType =
      software.amazon.awssdk.services.waf.model.ResourceType.UNKNOWN_TO_SDK_VERSION
  }
  case object APPLICATION_LOAD_BALANCER
      extends zio.aws.wafregional.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ResourceType =
      software.amazon.awssdk.services.waf.model.ResourceType.APPLICATION_LOAD_BALANCER
  }
  case object API_GATEWAY extends zio.aws.wafregional.model.ResourceType {
    override def unwrap
        : software.amazon.awssdk.services.waf.model.ResourceType =
      software.amazon.awssdk.services.waf.model.ResourceType.API_GATEWAY
  }
}
