package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetWebAclForResourceResponse(
    webACLSummary: Optional[zio.aws.wafregional.model.WebACLSummary] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse = {
    import GetWebAclForResourceResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
      .builder()
      .optionallyWith(webACLSummary.map(value => value.buildAwsValue()))(
        _.webACLSummary
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly =
    zio.aws.wafregional.model.GetWebAclForResourceResponse.wrap(buildAwsValue())
}
object GetWebAclForResourceResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetWebAclForResourceResponse =
      zio.aws.wafregional.model.GetWebAclForResourceResponse(
        webACLSummary.map(value => value.asEditable)
      )
    def webACLSummary
        : Optional[zio.aws.wafregional.model.WebACLSummary.ReadOnly]
    def getWebACLSummary
        : ZIO[Any, AwsError, zio.aws.wafregional.model.WebACLSummary.ReadOnly] =
      AwsError.unwrapOptionField("webACLSummary", webACLSummary)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
  ) extends zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly {
    override val webACLSummary
        : Optional[zio.aws.wafregional.model.WebACLSummary.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webACLSummary())
        .map(value => zio.aws.wafregional.model.WebACLSummary.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclForResourceResponse
  ): zio.aws.wafregional.model.GetWebAclForResourceResponse.ReadOnly =
    new Wrapper(impl)
}
