package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetIpSetResponse(
    ipSet: Optional[zio.aws.wafregional.model.IPSet] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetIpSetResponse = {
    import GetIpSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetIpSetResponse
      .builder()
      .optionallyWith(ipSet.map(value => value.buildAwsValue()))(_.ipSet)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetIpSetResponse.ReadOnly =
    zio.aws.wafregional.model.GetIpSetResponse.wrap(buildAwsValue())
}
object GetIpSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetIpSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetIpSetResponse =
      zio.aws.wafregional.model
        .GetIpSetResponse(ipSet.map(value => value.asEditable))
    def ipSet: Optional[zio.aws.wafregional.model.IPSet.ReadOnly]
    def getIpSet: ZIO[Any, AwsError, zio.aws.wafregional.model.IPSet.ReadOnly] =
      AwsError.unwrapOptionField("ipSet", ipSet)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetIpSetResponse
  ) extends zio.aws.wafregional.model.GetIpSetResponse.ReadOnly {
    override val ipSet: Optional[zio.aws.wafregional.model.IPSet.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ipSet())
        .map(value => zio.aws.wafregional.model.IPSet.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetIpSetResponse
  ): zio.aws.wafregional.model.GetIpSetResponse.ReadOnly = new Wrapper(impl)
}
