package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceName}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class CreateRegexPatternSetRequest(
    name: ResourceName,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateRegexPatternSetRequest = {
    import CreateRegexPatternSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateRegexPatternSetRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.CreateRegexPatternSetRequest.ReadOnly =
    zio.aws.wafregional.model.CreateRegexPatternSetRequest.wrap(buildAwsValue())
}
object CreateRegexPatternSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateRegexPatternSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateRegexPatternSetRequest =
      zio.aws.wafregional.model.CreateRegexPatternSetRequest(name, changeToken)
    def name: ResourceName
    def changeToken: ChangeToken
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexPatternSetRequest
  ) extends zio.aws.wafregional.model.CreateRegexPatternSetRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateRegexPatternSetRequest
  ): zio.aws.wafregional.model.CreateRegexPatternSetRequest.ReadOnly =
    new Wrapper(impl)
}
