package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class XssMatchSetUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    xssMatchTuple: zio.aws.wafregional.model.XssMatchTuple
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.XssMatchSetUpdate = {
    import XssMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .xssMatchTuple(xssMatchTuple.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.XssMatchSetUpdate.ReadOnly =
    zio.aws.wafregional.model.XssMatchSetUpdate.wrap(buildAwsValue())
}
object XssMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.XssMatchSetUpdate =
      zio.aws.wafregional.model
        .XssMatchSetUpdate(action, xssMatchTuple.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def xssMatchTuple: zio.aws.wafregional.model.XssMatchTuple.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getXssMatchTuple
        : ZIO[Any, Nothing, zio.aws.wafregional.model.XssMatchTuple.ReadOnly] =
      ZIO.succeed(xssMatchTuple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
  ) extends zio.aws.wafregional.model.XssMatchSetUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val xssMatchTuple
        : zio.aws.wafregional.model.XssMatchTuple.ReadOnly =
      zio.aws.wafregional.model.XssMatchTuple.wrap(impl.xssMatchTuple())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchSetUpdate
  ): zio.aws.wafregional.model.XssMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
