package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class SqlInjectionMatchSet(
    sqlInjectionMatchSetId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    sqlInjectionMatchTuples: Iterable[
      zio.aws.wafregional.model.SqlInjectionMatchTuple
    ]
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet = {
    import SqlInjectionMatchSet.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
      .builder()
      .sqlInjectionMatchSetId(
        ResourceId.unwrap(sqlInjectionMatchSetId): java.lang.String
      )
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .sqlInjectionMatchTuples(sqlInjectionMatchTuples.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly =
    zio.aws.wafregional.model.SqlInjectionMatchSet.wrap(buildAwsValue())
}
object SqlInjectionMatchSet {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.SqlInjectionMatchSet =
      zio.aws.wafregional.model.SqlInjectionMatchSet(
        sqlInjectionMatchSetId,
        name.map(value => value),
        sqlInjectionMatchTuples.map { item =>
          item.asEditable
        }
      )
    def sqlInjectionMatchSetId: ResourceId
    def name: Optional[ResourceName]
    def sqlInjectionMatchTuples
        : List[zio.aws.wafregional.model.SqlInjectionMatchTuple.ReadOnly]
    def getSqlInjectionMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(sqlInjectionMatchSetId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getSqlInjectionMatchTuples: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.SqlInjectionMatchTuple.ReadOnly
    ]] = ZIO.succeed(sqlInjectionMatchTuples)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
  ) extends zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly {
    override val sqlInjectionMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives
        .ResourceId(impl.sqlInjectionMatchSetId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.ResourceName(value))
    override val sqlInjectionMatchTuples
        : List[zio.aws.wafregional.model.SqlInjectionMatchTuple.ReadOnly] = impl
      .sqlInjectionMatchTuples()
      .asScala
      .map { item =>
        zio.aws.wafregional.model.SqlInjectionMatchTuple.wrap(item)
      }
      .toList
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SqlInjectionMatchSet
  ): zio.aws.wafregional.model.SqlInjectionMatchSet.ReadOnly = new Wrapper(impl)
}
