package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteXssMatchSetResponse(
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteXssMatchSetResponse = {
    import DeleteXssMatchSetResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteXssMatchSetResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteXssMatchSetResponse.ReadOnly =
    zio.aws.wafregional.model.DeleteXssMatchSetResponse.wrap(buildAwsValue())
}
object DeleteXssMatchSetResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteXssMatchSetResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteXssMatchSetResponse =
      zio.aws.wafregional.model
        .DeleteXssMatchSetResponse(changeToken.map(value => value))
    def changeToken: Optional[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteXssMatchSetResponse
  ) extends zio.aws.wafregional.model.DeleteXssMatchSetResponse.ReadOnly {
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteXssMatchSetResponse
  ): zio.aws.wafregional.model.DeleteXssMatchSetResponse.ReadOnly = new Wrapper(
    impl
  )
}
