package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetWebAclResponse(
    webACL: Optional[zio.aws.wafregional.model.WebACL] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetWebAclResponse = {
    import GetWebAclResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetWebAclResponse
      .builder()
      .optionallyWith(webACL.map(value => value.buildAwsValue()))(_.webACL)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetWebAclResponse.ReadOnly =
    zio.aws.wafregional.model.GetWebAclResponse.wrap(buildAwsValue())
}
object GetWebAclResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetWebAclResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetWebAclResponse =
      zio.aws.wafregional.model
        .GetWebAclResponse(webACL.map(value => value.asEditable))
    def webACL: Optional[zio.aws.wafregional.model.WebACL.ReadOnly]
    def getWebACL
        : ZIO[Any, AwsError, zio.aws.wafregional.model.WebACL.ReadOnly] =
      AwsError.unwrapOptionField("webACL", webACL)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclResponse
  ) extends zio.aws.wafregional.model.GetWebAclResponse.ReadOnly {
    override val webACL: Optional[zio.aws.wafregional.model.WebACL.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.webACL())
        .map(value => zio.aws.wafregional.model.WebACL.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetWebAclResponse
  ): zio.aws.wafregional.model.GetWebAclResponse.ReadOnly = new Wrapper(impl)
}
