package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegexMatchTuple(
    fieldToMatch: zio.aws.wafregional.model.FieldToMatch,
    textTransformation: zio.aws.wafregional.model.TextTransformation,
    regexPatternSetId: ResourceId
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexMatchTuple = {
    import RegexMatchTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexMatchTuple
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformation(textTransformation.unwrap)
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RegexMatchTuple.ReadOnly =
    zio.aws.wafregional.model.RegexMatchTuple.wrap(buildAwsValue())
}
object RegexMatchTuple {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexMatchTuple
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RegexMatchTuple =
      zio.aws.wafregional.model.RegexMatchTuple(
        fieldToMatch.asEditable,
        textTransformation,
        regexPatternSetId
      )
    def fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly
    def textTransformation: zio.aws.wafregional.model.TextTransformation
    def regexPatternSetId: ResourceId
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafregional.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.wafregional.model.TextTransformation] =
      ZIO.succeed(textTransformation)
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchTuple
  ) extends zio.aws.wafregional.model.RegexMatchTuple.ReadOnly {
    override val fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly =
      zio.aws.wafregional.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformation
        : zio.aws.wafregional.model.TextTransformation =
      zio.aws.wafregional.model.TextTransformation
        .wrap(impl.textTransformation())
    override val regexPatternSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexPatternSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchTuple
  ): zio.aws.wafregional.model.RegexMatchTuple.ReadOnly = new Wrapper(impl)
}
