package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetXssMatchSetRequest(xssMatchSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest = {
    import GetXssMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
      .builder()
      .xssMatchSetId(ResourceId.unwrap(xssMatchSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetXssMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.GetXssMatchSetRequest.wrap(buildAwsValue())
}
object GetXssMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetXssMatchSetRequest =
      zio.aws.wafregional.model.GetXssMatchSetRequest(xssMatchSetId)
    def xssMatchSetId: ResourceId
    def getXssMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(xssMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
  ) extends zio.aws.wafregional.model.GetXssMatchSetRequest.ReadOnly {
    override val xssMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.xssMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetXssMatchSetRequest
  ): zio.aws.wafregional.model.GetXssMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
