package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRuleResponse(
    rule: Optional[zio.aws.wafregional.model.Rule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRuleResponse = {
    import GetRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRuleResponse
      .builder()
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetRuleResponse.ReadOnly =
    zio.aws.wafregional.model.GetRuleResponse.wrap(buildAwsValue())
}
object GetRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRuleResponse =
      zio.aws.wafregional.model
        .GetRuleResponse(rule.map(value => value.asEditable))
    def rule: Optional[zio.aws.wafregional.model.Rule.ReadOnly]
    def getRule: ZIO[Any, AwsError, zio.aws.wafregional.model.Rule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRuleResponse
  ) extends zio.aws.wafregional.model.GetRuleResponse.ReadOnly {
    override val rule: Optional[zio.aws.wafregional.model.Rule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.wafregional.model.Rule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRuleResponse
  ): zio.aws.wafregional.model.GetRuleResponse.ReadOnly = new Wrapper(impl)
}
