package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRuleGroupResponse(
    ruleGroup: Optional[zio.aws.wafregional.model.RuleGroup] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRuleGroupResponse = {
    import GetRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRuleGroupResponse
      .builder()
      .optionallyWith(ruleGroup.map(value => value.buildAwsValue()))(
        _.ruleGroup
      )
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetRuleGroupResponse.ReadOnly =
    zio.aws.wafregional.model.GetRuleGroupResponse.wrap(buildAwsValue())
}
object GetRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRuleGroupResponse =
      zio.aws.wafregional.model
        .GetRuleGroupResponse(ruleGroup.map(value => value.asEditable))
    def ruleGroup: Optional[zio.aws.wafregional.model.RuleGroup.ReadOnly]
    def getRuleGroup
        : ZIO[Any, AwsError, zio.aws.wafregional.model.RuleGroup.ReadOnly] =
      AwsError.unwrapOptionField("ruleGroup", ruleGroup)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRuleGroupResponse
  ) extends zio.aws.wafregional.model.GetRuleGroupResponse.ReadOnly {
    override val ruleGroup
        : Optional[zio.aws.wafregional.model.RuleGroup.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.ruleGroup())
        .map(value => zio.aws.wafregional.model.RuleGroup.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRuleGroupResponse
  ): zio.aws.wafregional.model.GetRuleGroupResponse.ReadOnly = new Wrapper(impl)
}
