package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetByteMatchSetRequest(byteMatchSetId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest = {
    import GetByteMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
      .builder()
      .byteMatchSetId(ResourceId.unwrap(byteMatchSetId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetByteMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.GetByteMatchSetRequest.wrap(buildAwsValue())
}
object GetByteMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetByteMatchSetRequest =
      zio.aws.wafregional.model.GetByteMatchSetRequest(byteMatchSetId)
    def byteMatchSetId: ResourceId
    def getByteMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(byteMatchSetId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
  ) extends zio.aws.wafregional.model.GetByteMatchSetRequest.ReadOnly {
    override val byteMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.byteMatchSetId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetByteMatchSetRequest
  ): zio.aws.wafregional.model.GetByteMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
