package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class XssMatchTuple(
    fieldToMatch: zio.aws.wafregional.model.FieldToMatch,
    textTransformation: zio.aws.wafregional.model.TextTransformation
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.XssMatchTuple = {
    import XssMatchTuple.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.XssMatchTuple
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformation(textTransformation.unwrap)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.XssMatchTuple.ReadOnly =
    zio.aws.wafregional.model.XssMatchTuple.wrap(buildAwsValue())
}
object XssMatchTuple {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.XssMatchTuple] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.XssMatchTuple =
      zio.aws.wafregional.model
        .XssMatchTuple(fieldToMatch.asEditable, textTransformation)
    def fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly
    def textTransformation: zio.aws.wafregional.model.TextTransformation
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafregional.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.wafregional.model.TextTransformation] =
      ZIO.succeed(textTransformation)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.XssMatchTuple
  ) extends zio.aws.wafregional.model.XssMatchTuple.ReadOnly {
    override val fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly =
      zio.aws.wafregional.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformation
        : zio.aws.wafregional.model.TextTransformation =
      zio.aws.wafregional.model.TextTransformation
        .wrap(impl.textTransformation())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.XssMatchTuple
  ): zio.aws.wafregional.model.XssMatchTuple.ReadOnly = new Wrapper(impl)
}
