package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.Size
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class SizeConstraint(
    fieldToMatch: zio.aws.wafregional.model.FieldToMatch,
    textTransformation: zio.aws.wafregional.model.TextTransformation,
    comparisonOperator: zio.aws.wafregional.model.ComparisonOperator,
    size: Size
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.SizeConstraint = {
    import SizeConstraint.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.SizeConstraint
      .builder()
      .fieldToMatch(fieldToMatch.buildAwsValue())
      .textTransformation(textTransformation.unwrap)
      .comparisonOperator(comparisonOperator.unwrap)
      .size(Size.unwrap(size): java.lang.Long)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.SizeConstraint.ReadOnly =
    zio.aws.wafregional.model.SizeConstraint.wrap(buildAwsValue())
}
object SizeConstraint {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.SizeConstraint
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.SizeConstraint =
      zio.aws.wafregional.model.SizeConstraint(
        fieldToMatch.asEditable,
        textTransformation,
        comparisonOperator,
        size
      )
    def fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly
    def textTransformation: zio.aws.wafregional.model.TextTransformation
    def comparisonOperator: zio.aws.wafregional.model.ComparisonOperator
    def size: Size
    def getFieldToMatch
        : ZIO[Any, Nothing, zio.aws.wafregional.model.FieldToMatch.ReadOnly] =
      ZIO.succeed(fieldToMatch)
    def getTextTransformation
        : ZIO[Any, Nothing, zio.aws.wafregional.model.TextTransformation] =
      ZIO.succeed(textTransformation)
    def getComparisonOperator
        : ZIO[Any, Nothing, zio.aws.wafregional.model.ComparisonOperator] =
      ZIO.succeed(comparisonOperator)
    def getSize: ZIO[Any, Nothing, Size] = ZIO.succeed(size)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraint
  ) extends zio.aws.wafregional.model.SizeConstraint.ReadOnly {
    override val fieldToMatch: zio.aws.wafregional.model.FieldToMatch.ReadOnly =
      zio.aws.wafregional.model.FieldToMatch.wrap(impl.fieldToMatch())
    override val textTransformation
        : zio.aws.wafregional.model.TextTransformation =
      zio.aws.wafregional.model.TextTransformation
        .wrap(impl.textTransformation())
    override val comparisonOperator
        : zio.aws.wafregional.model.ComparisonOperator =
      zio.aws.wafregional.model.ComparisonOperator
        .wrap(impl.comparisonOperator())
    override val size: Size =
      zio.aws.wafregional.model.primitives.Size(impl.size())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.SizeConstraint
  ): zio.aws.wafregional.model.SizeConstraint.ReadOnly = new Wrapper(impl)
}
