package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.RegexPatternString
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegexPatternSetUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    regexPatternString: RegexPatternString
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate = {
    import RegexPatternSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
      .builder()
      .action(action.unwrap)
      .regexPatternString(
        RegexPatternString.unwrap(regexPatternString): java.lang.String
      )
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RegexPatternSetUpdate.ReadOnly =
    zio.aws.wafregional.model.RegexPatternSetUpdate.wrap(buildAwsValue())
}
object RegexPatternSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RegexPatternSetUpdate =
      zio.aws.wafregional.model
        .RegexPatternSetUpdate(action, regexPatternString)
    def action: zio.aws.wafregional.model.ChangeAction
    def regexPatternString: RegexPatternString
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getRegexPatternString: ZIO[Any, Nothing, RegexPatternString] =
      ZIO.succeed(regexPatternString)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
  ) extends zio.aws.wafregional.model.RegexPatternSetUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val regexPatternString: RegexPatternString =
      zio.aws.wafregional.model.primitives
        .RegexPatternString(impl.regexPatternString())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetUpdate
  ): zio.aws.wafregional.model.RegexPatternSetUpdate.ReadOnly = new Wrapper(
    impl
  )
}
