package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetRateBasedRuleResponse(
    rule: Optional[zio.aws.wafregional.model.RateBasedRule] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRateBasedRuleResponse = {
    import GetRateBasedRuleResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleResponse
      .builder()
      .optionallyWith(rule.map(value => value.buildAwsValue()))(_.rule)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetRateBasedRuleResponse.ReadOnly =
    zio.aws.wafregional.model.GetRateBasedRuleResponse.wrap(buildAwsValue())
}
object GetRateBasedRuleResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRateBasedRuleResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRateBasedRuleResponse =
      zio.aws.wafregional.model
        .GetRateBasedRuleResponse(rule.map(value => value.asEditable))
    def rule: Optional[zio.aws.wafregional.model.RateBasedRule.ReadOnly]
    def getRule
        : ZIO[Any, AwsError, zio.aws.wafregional.model.RateBasedRule.ReadOnly] =
      AwsError.unwrapOptionField("rule", rule)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleResponse
  ) extends zio.aws.wafregional.model.GetRateBasedRuleResponse.ReadOnly {
    override val rule
        : Optional[zio.aws.wafregional.model.RateBasedRule.ReadOnly] =
      zio.aws.core.internal
        .optionalFromNullable(impl.rule())
        .map(value => zio.aws.wafregional.model.RateBasedRule.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRateBasedRuleResponse
  ): zio.aws.wafregional.model.GetRateBasedRuleResponse.ReadOnly = new Wrapper(
    impl
  )
}
