package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class DeleteGeoMatchSetRequest(
    geoMatchSetId: ResourceId,
    changeToken: ChangeToken
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest = {
    import DeleteGeoMatchSetRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
      .builder()
      .geoMatchSetId(ResourceId.unwrap(geoMatchSetId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteGeoMatchSetRequest.ReadOnly =
    zio.aws.wafregional.model.DeleteGeoMatchSetRequest.wrap(buildAwsValue())
}
object DeleteGeoMatchSetRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteGeoMatchSetRequest =
      zio.aws.wafregional.model
        .DeleteGeoMatchSetRequest(geoMatchSetId, changeToken)
    def geoMatchSetId: ResourceId
    def changeToken: ChangeToken
    def getGeoMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(geoMatchSetId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
  ) extends zio.aws.wafregional.model.DeleteGeoMatchSetRequest.ReadOnly {
    override val geoMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.geoMatchSetId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteGeoMatchSetRequest
  ): zio.aws.wafregional.model.DeleteGeoMatchSetRequest.ReadOnly = new Wrapper(
    impl
  )
}
