package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegexPatternSetSummary(
    regexPatternSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexPatternSetSummary = {
    import RegexPatternSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
      .builder()
      .regexPatternSetId(ResourceId.unwrap(regexPatternSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RegexPatternSetSummary.ReadOnly =
    zio.aws.wafregional.model.RegexPatternSetSummary.wrap(buildAwsValue())
}
object RegexPatternSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RegexPatternSetSummary =
      zio.aws.wafregional.model.RegexPatternSetSummary(regexPatternSetId, name)
    def regexPatternSetId: ResourceId
    def name: ResourceName
    def getRegexPatternSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexPatternSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
  ) extends zio.aws.wafregional.model.RegexPatternSetSummary.ReadOnly {
    override val regexPatternSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexPatternSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexPatternSetSummary
  ): zio.aws.wafregional.model.RegexPatternSetSummary.ReadOnly = new Wrapper(
    impl
  )
}
