package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  IPString,
  HTTPVersion,
  HTTPMethod,
  URIString,
  Country
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class HTTPRequest(
    clientIP: Optional[IPString] = Optional.Absent,
    country: Optional[Country] = Optional.Absent,
    uri: Optional[URIString] = Optional.Absent,
    method: Optional[HTTPMethod] = Optional.Absent,
    httpVersion: Optional[HTTPVersion] = Optional.Absent,
    headers: Optional[Iterable[zio.aws.wafregional.model.HTTPHeader]] =
      Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.HTTPRequest = {
    import HTTPRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.HTTPRequest
      .builder()
      .optionallyWith(
        clientIP.map(value => IPString.unwrap(value): java.lang.String)
      )(_.clientIP)
      .optionallyWith(
        country.map(value => Country.unwrap(value): java.lang.String)
      )(_.country)
      .optionallyWith(
        uri.map(value => URIString.unwrap(value): java.lang.String)
      )(_.uri)
      .optionallyWith(
        method.map(value => HTTPMethod.unwrap(value): java.lang.String)
      )(_.method)
      .optionallyWith(
        httpVersion.map(value => HTTPVersion.unwrap(value): java.lang.String)
      )(_.httpVersion)
      .optionallyWith(
        headers.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.headers)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.HTTPRequest.ReadOnly =
    zio.aws.wafregional.model.HTTPRequest.wrap(buildAwsValue())
}
object HTTPRequest {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.HTTPRequest] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.HTTPRequest =
      zio.aws.wafregional.model.HTTPRequest(
        clientIP.map(value => value),
        country.map(value => value),
        uri.map(value => value),
        method.map(value => value),
        httpVersion.map(value => value),
        headers.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def clientIP: Optional[IPString]
    def country: Optional[Country]
    def uri: Optional[URIString]
    def method: Optional[HTTPMethod]
    def httpVersion: Optional[HTTPVersion]
    def headers: Optional[List[zio.aws.wafregional.model.HTTPHeader.ReadOnly]]
    def getClientIP: ZIO[Any, AwsError, IPString] =
      AwsError.unwrapOptionField("clientIP", clientIP)
    def getCountry: ZIO[Any, AwsError, Country] =
      AwsError.unwrapOptionField("country", country)
    def getUri: ZIO[Any, AwsError, URIString] =
      AwsError.unwrapOptionField("uri", uri)
    def getMethod: ZIO[Any, AwsError, HTTPMethod] =
      AwsError.unwrapOptionField("method", method)
    def getHttpVersion: ZIO[Any, AwsError, HTTPVersion] =
      AwsError.unwrapOptionField("httpVersion", httpVersion)
    def getHeaders: ZIO[Any, AwsError, List[
      zio.aws.wafregional.model.HTTPHeader.ReadOnly
    ]] = AwsError.unwrapOptionField("headers", headers)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.HTTPRequest
  ) extends zio.aws.wafregional.model.HTTPRequest.ReadOnly {
    override val clientIP: Optional[IPString] = zio.aws.core.internal
      .optionalFromNullable(impl.clientIP())
      .map(value => zio.aws.wafregional.model.primitives.IPString(value))
    override val country: Optional[Country] = zio.aws.core.internal
      .optionalFromNullable(impl.country())
      .map(value => zio.aws.wafregional.model.primitives.Country(value))
    override val uri: Optional[URIString] = zio.aws.core.internal
      .optionalFromNullable(impl.uri())
      .map(value => zio.aws.wafregional.model.primitives.URIString(value))
    override val method: Optional[HTTPMethod] = zio.aws.core.internal
      .optionalFromNullable(impl.method())
      .map(value => zio.aws.wafregional.model.primitives.HTTPMethod(value))
    override val httpVersion: Optional[HTTPVersion] = zio.aws.core.internal
      .optionalFromNullable(impl.httpVersion())
      .map(value => zio.aws.wafregional.model.primitives.HTTPVersion(value))
    override val headers
        : Optional[List[zio.aws.wafregional.model.HTTPHeader.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.headers())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafregional.model.HTTPHeader.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.HTTPRequest
  ): zio.aws.wafregional.model.HTTPRequest.ReadOnly = new Wrapper(impl)
}
