package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GeoMatchSetUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    geoMatchConstraint: zio.aws.wafregional.model.GeoMatchConstraint
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate = {
    import GeoMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .geoMatchConstraint(geoMatchConstraint.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GeoMatchSetUpdate.ReadOnly =
    zio.aws.wafregional.model.GeoMatchSetUpdate.wrap(buildAwsValue())
}
object GeoMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GeoMatchSetUpdate =
      zio.aws.wafregional.model
        .GeoMatchSetUpdate(action, geoMatchConstraint.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def geoMatchConstraint
        : zio.aws.wafregional.model.GeoMatchConstraint.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getGeoMatchConstraint: ZIO[
      Any,
      Nothing,
      zio.aws.wafregional.model.GeoMatchConstraint.ReadOnly
    ] = ZIO.succeed(geoMatchConstraint)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
  ) extends zio.aws.wafregional.model.GeoMatchSetUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val geoMatchConstraint
        : zio.aws.wafregional.model.GeoMatchConstraint.ReadOnly =
      zio.aws.wafregional.model.GeoMatchConstraint
        .wrap(impl.geoMatchConstraint())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GeoMatchSetUpdate
  ): zio.aws.wafregional.model.GeoMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
