package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.MatchFieldData
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class FieldToMatch(
    `type`: zio.aws.wafregional.model.MatchFieldType,
    data: Optional[MatchFieldData] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.FieldToMatch = {
    import FieldToMatch.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.FieldToMatch
      .builder()
      .`type`(`type`.unwrap)
      .optionallyWith(
        data.map(value => MatchFieldData.unwrap(value): java.lang.String)
      )(_.data)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.FieldToMatch.ReadOnly =
    zio.aws.wafregional.model.FieldToMatch.wrap(buildAwsValue())
}
object FieldToMatch {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.FieldToMatch] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.FieldToMatch =
      zio.aws.wafregional.model.FieldToMatch(`type`, data.map(value => value))
    def `type`: zio.aws.wafregional.model.MatchFieldType
    def data: Optional[MatchFieldData]
    def getType: ZIO[Any, Nothing, zio.aws.wafregional.model.MatchFieldType] =
      ZIO.succeed(`type`)
    def getData: ZIO[Any, AwsError, MatchFieldData] =
      AwsError.unwrapOptionField("data", data)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.FieldToMatch
  ) extends zio.aws.wafregional.model.FieldToMatch.ReadOnly {
    override val `type`: zio.aws.wafregional.model.MatchFieldType =
      zio.aws.wafregional.model.MatchFieldType.wrap(impl.`type`())
    override val data: Optional[MatchFieldData] = zio.aws.core.internal
      .optionalFromNullable(impl.data())
      .map(value => zio.aws.wafregional.model.primitives.MatchFieldData(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.FieldToMatch
  ): zio.aws.wafregional.model.FieldToMatch.ReadOnly = new Wrapper(impl)
}
