package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  ResourceArn,
  MetricName,
  ResourceName,
  ResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class WebACL(
    webACLId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent,
    defaultAction: zio.aws.wafregional.model.WafAction,
    rules: Iterable[zio.aws.wafregional.model.ActivatedRule],
    webACLArn: Optional[ResourceArn] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.WebACL = {
    import WebACL.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.WebACL
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .defaultAction(defaultAction.buildAwsValue())
      .rules(rules.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .optionallyWith(
        webACLArn.map(value => ResourceArn.unwrap(value): java.lang.String)
      )(_.webACLArn)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.WebACL.ReadOnly =
    zio.aws.wafregional.model.WebACL.wrap(buildAwsValue())
}
object WebACL {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.WebACL] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.WebACL =
      zio.aws.wafregional.model.WebACL(
        webACLId,
        name.map(value => value),
        metricName.map(value => value),
        defaultAction.asEditable,
        rules.map { item =>
          item.asEditable
        },
        webACLArn.map(value => value)
      )
    def webACLId: ResourceId
    def name: Optional[ResourceName]
    def metricName: Optional[MetricName]
    def defaultAction: zio.aws.wafregional.model.WafAction.ReadOnly
    def rules: List[zio.aws.wafregional.model.ActivatedRule.ReadOnly]
    def webACLArn: Optional[ResourceArn]
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.wafregional.model.WafAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getRules: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.ActivatedRule.ReadOnly
    ]] = ZIO.succeed(rules)
    def getWebACLArn: ZIO[Any, AwsError, ResourceArn] =
      AwsError.unwrapOptionField("webACLArn", webACLArn)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.WebACL
  ) extends zio.aws.wafregional.model.WebACL.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.webACLId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.ResourceName(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.wafregional.model.primitives.MetricName(value))
    override val defaultAction: zio.aws.wafregional.model.WafAction.ReadOnly =
      zio.aws.wafregional.model.WafAction.wrap(impl.defaultAction())
    override val rules: List[zio.aws.wafregional.model.ActivatedRule.ReadOnly] =
      impl
        .rules()
        .asScala
        .map { item =>
          zio.aws.wafregional.model.ActivatedRule.wrap(item)
        }
        .toList
    override val webACLArn: Optional[ResourceArn] = zio.aws.core.internal
      .optionalFromNullable(impl.webACLArn())
      .map(value => zio.aws.wafregional.model.primitives.ResourceArn(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.WebACL
  ): zio.aws.wafregional.model.WebACL.ReadOnly = new Wrapper(impl)
}
