package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ResourceId
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class GetRuleGroupRequest(ruleGroupId: ResourceId) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetRuleGroupRequest = {
    import GetRuleGroupRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.GetRuleGroupRequest.ReadOnly =
    zio.aws.wafregional.model.GetRuleGroupRequest.wrap(buildAwsValue())
}
object GetRuleGroupRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetRuleGroupRequest =
      zio.aws.wafregional.model.GetRuleGroupRequest(ruleGroupId)
    def ruleGroupId: ResourceId
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
  ) extends zio.aws.wafregional.model.GetRuleGroupRequest.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleGroupId())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetRuleGroupRequest
  ): zio.aws.wafregional.model.GetRuleGroupRequest.ReadOnly = new Wrapper(impl)
}
