package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class WebACLSummary(webACLId: ResourceId, name: ResourceName) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.WebACLSummary = {
    import WebACLSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.WebACLSummary
      .builder()
      .webACLId(ResourceId.unwrap(webACLId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.WebACLSummary.ReadOnly =
    zio.aws.wafregional.model.WebACLSummary.wrap(buildAwsValue())
}
object WebACLSummary {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.WebACLSummary] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.WebACLSummary =
      zio.aws.wafregional.model.WebACLSummary(webACLId, name)
    def webACLId: ResourceId
    def name: ResourceName
    def getWebACLId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(webACLId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.WebACLSummary
  ) extends zio.aws.wafregional.model.WebACLSummary.ReadOnly {
    override val webACLId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.webACLId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.WebACLSummary
  ): zio.aws.wafregional.model.WebACLSummary.ReadOnly = new Wrapper(impl)
}
