package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{RateLimit, ChangeToken, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class UpdateRateBasedRuleRequest(
    ruleId: ResourceId,
    changeToken: ChangeToken,
    updates: Iterable[zio.aws.wafregional.model.RuleUpdate],
    rateLimit: RateLimit
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.UpdateRateBasedRuleRequest = {
    import UpdateRateBasedRuleRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.UpdateRateBasedRuleRequest
      .builder()
      .ruleId(ResourceId.unwrap(ruleId): java.lang.String)
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .updates(updates.map { item =>
        item.buildAwsValue()
      }.asJavaCollection)
      .rateLimit(RateLimit.unwrap(rateLimit): java.lang.Long)
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.UpdateRateBasedRuleRequest.ReadOnly =
    zio.aws.wafregional.model.UpdateRateBasedRuleRequest.wrap(buildAwsValue())
}
object UpdateRateBasedRuleRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.UpdateRateBasedRuleRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.UpdateRateBasedRuleRequest =
      zio.aws.wafregional.model.UpdateRateBasedRuleRequest(
        ruleId,
        changeToken,
        updates.map { item =>
          item.asEditable
        },
        rateLimit
      )
    def ruleId: ResourceId
    def changeToken: ChangeToken
    def updates: List[zio.aws.wafregional.model.RuleUpdate.ReadOnly]
    def rateLimit: RateLimit
    def getRuleId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleId)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getUpdates: ZIO[Any, Nothing, List[
      zio.aws.wafregional.model.RuleUpdate.ReadOnly
    ]] = ZIO.succeed(updates)
    def getRateLimit: ZIO[Any, Nothing, RateLimit] = ZIO.succeed(rateLimit)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.UpdateRateBasedRuleRequest
  ) extends zio.aws.wafregional.model.UpdateRateBasedRuleRequest.ReadOnly {
    override val ruleId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleId())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
    override val updates: List[zio.aws.wafregional.model.RuleUpdate.ReadOnly] =
      impl
        .updates()
        .asScala
        .map { item =>
          zio.aws.wafregional.model.RuleUpdate.wrap(item)
        }
        .toList
    override val rateLimit: RateLimit =
      zio.aws.wafregional.model.primitives.RateLimit(impl.rateLimit())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.UpdateRateBasedRuleRequest
  ): zio.aws.wafregional.model.UpdateRateBasedRuleRequest.ReadOnly =
    new Wrapper(impl)
}
