package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  MetricName,
  ResourceName,
  ResourceId
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class RuleGroup(
    ruleGroupId: ResourceId,
    name: Optional[ResourceName] = Optional.Absent,
    metricName: Optional[MetricName] = Optional.Absent
) {
  def buildAwsValue(): software.amazon.awssdk.services.waf.model.RuleGroup = {
    import RuleGroup.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RuleGroup
      .builder()
      .ruleGroupId(ResourceId.unwrap(ruleGroupId): java.lang.String)
      .optionallyWith(
        name.map(value => ResourceName.unwrap(value): java.lang.String)
      )(_.name)
      .optionallyWith(
        metricName.map(value => MetricName.unwrap(value): java.lang.String)
      )(_.metricName)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RuleGroup.ReadOnly =
    zio.aws.wafregional.model.RuleGroup.wrap(buildAwsValue())
}
object RuleGroup {
  private lazy val zioAwsBuilderHelper
      : BuilderHelper[software.amazon.awssdk.services.waf.model.RuleGroup] =
    BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RuleGroup =
      zio.aws.wafregional.model.RuleGroup(
        ruleGroupId,
        name.map(value => value),
        metricName.map(value => value)
      )
    def ruleGroupId: ResourceId
    def name: Optional[ResourceName]
    def metricName: Optional[MetricName]
    def getRuleGroupId: ZIO[Any, Nothing, ResourceId] = ZIO.succeed(ruleGroupId)
    def getName: ZIO[Any, AwsError, ResourceName] =
      AwsError.unwrapOptionField("name", name)
    def getMetricName: ZIO[Any, AwsError, MetricName] =
      AwsError.unwrapOptionField("metricName", metricName)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RuleGroup
  ) extends zio.aws.wafregional.model.RuleGroup.ReadOnly {
    override val ruleGroupId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.ruleGroupId())
    override val name: Optional[ResourceName] = zio.aws.core.internal
      .optionalFromNullable(impl.name())
      .map(value => zio.aws.wafregional.model.primitives.ResourceName(value))
    override val metricName: Optional[MetricName] = zio.aws.core.internal
      .optionalFromNullable(impl.metricName())
      .map(value => zio.aws.wafregional.model.primitives.MetricName(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RuleGroup
  ): zio.aws.wafregional.model.RuleGroup.ReadOnly = new Wrapper(impl)
}
