package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{ResourceName, ResourceId}
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class RegexMatchSetSummary(
    regexMatchSetId: ResourceId,
    name: ResourceName
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.RegexMatchSetSummary = {
    import RegexMatchSetSummary.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
      .builder()
      .regexMatchSetId(ResourceId.unwrap(regexMatchSetId): java.lang.String)
      .name(ResourceName.unwrap(name): java.lang.String)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.RegexMatchSetSummary.ReadOnly =
    zio.aws.wafregional.model.RegexMatchSetSummary.wrap(buildAwsValue())
}
object RegexMatchSetSummary {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.RegexMatchSetSummary =
      zio.aws.wafregional.model.RegexMatchSetSummary(regexMatchSetId, name)
    def regexMatchSetId: ResourceId
    def name: ResourceName
    def getRegexMatchSetId: ZIO[Any, Nothing, ResourceId] =
      ZIO.succeed(regexMatchSetId)
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
  ) extends zio.aws.wafregional.model.RegexMatchSetSummary.ReadOnly {
    override val regexMatchSetId: ResourceId =
      zio.aws.wafregional.model.primitives.ResourceId(impl.regexMatchSetId())
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.RegexMatchSetSummary
  ): zio.aws.wafregional.model.RegexMatchSetSummary.ReadOnly = new Wrapper(impl)
}
