package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class GetChangeTokenStatusResponse(
    changeTokenStatus: Optional[zio.aws.wafregional.model.ChangeTokenStatus] =
      Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse = {
    import GetChangeTokenStatusResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
      .builder()
      .optionallyWith(changeTokenStatus.map(value => value.unwrap))(
        _.changeTokenStatus
      )
      .build()
  }
  def asReadOnly
      : zio.aws.wafregional.model.GetChangeTokenStatusResponse.ReadOnly =
    zio.aws.wafregional.model.GetChangeTokenStatusResponse.wrap(buildAwsValue())
}
object GetChangeTokenStatusResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.GetChangeTokenStatusResponse =
      zio.aws.wafregional.model
        .GetChangeTokenStatusResponse(changeTokenStatus.map(value => value))
    def changeTokenStatus: Optional[zio.aws.wafregional.model.ChangeTokenStatus]
    def getChangeTokenStatus
        : ZIO[Any, AwsError, zio.aws.wafregional.model.ChangeTokenStatus] =
      AwsError.unwrapOptionField("changeTokenStatus", changeTokenStatus)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
  ) extends zio.aws.wafregional.model.GetChangeTokenStatusResponse.ReadOnly {
    override val changeTokenStatus
        : Optional[zio.aws.wafregional.model.ChangeTokenStatus] =
      zio.aws.core.internal
        .optionalFromNullable(impl.changeTokenStatus())
        .map(value => zio.aws.wafregional.model.ChangeTokenStatus.wrap(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.GetChangeTokenStatusResponse
  ): zio.aws.wafregional.model.GetChangeTokenStatusResponse.ReadOnly =
    new Wrapper(impl)
}
