package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.ChangeToken
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class DeleteRuleGroupResponse(
    changeToken: Optional[ChangeToken] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse = {
    import DeleteRuleGroupResponse.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
      .builder()
      .optionallyWith(
        changeToken.map(value => ChangeToken.unwrap(value): java.lang.String)
      )(_.changeToken)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.DeleteRuleGroupResponse.ReadOnly =
    zio.aws.wafregional.model.DeleteRuleGroupResponse.wrap(buildAwsValue())
}
object DeleteRuleGroupResponse {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.DeleteRuleGroupResponse =
      zio.aws.wafregional.model
        .DeleteRuleGroupResponse(changeToken.map(value => value))
    def changeToken: Optional[ChangeToken]
    def getChangeToken: ZIO[Any, AwsError, ChangeToken] =
      AwsError.unwrapOptionField("changeToken", changeToken)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
  ) extends zio.aws.wafregional.model.DeleteRuleGroupResponse.ReadOnly {
    override val changeToken: Optional[ChangeToken] = zio.aws.core.internal
      .optionalFromNullable(impl.changeToken())
      .map(value => zio.aws.wafregional.model.primitives.ChangeToken(value))
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.DeleteRuleGroupResponse
  ): zio.aws.wafregional.model.DeleteRuleGroupResponse.ReadOnly = new Wrapper(
    impl
  )
}
