package zio.aws.wafregional.model
import zio.aws.wafregional.model.primitives.{
  ChangeToken,
  MetricName,
  ResourceName
}
import zio.ZIO
import zio.aws.core.{AwsError, BuilderHelper}
import zio.prelude.data.Optional
import scala.jdk.CollectionConverters.*
final case class CreateWebAclRequest(
    name: ResourceName,
    metricName: MetricName,
    defaultAction: zio.aws.wafregional.model.WafAction,
    changeToken: ChangeToken,
    tags: Optional[Iterable[zio.aws.wafregional.model.Tag]] = Optional.Absent
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.CreateWebAclRequest = {
    import CreateWebAclRequest.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.CreateWebAclRequest
      .builder()
      .name(ResourceName.unwrap(name): java.lang.String)
      .metricName(MetricName.unwrap(metricName): java.lang.String)
      .defaultAction(defaultAction.buildAwsValue())
      .changeToken(ChangeToken.unwrap(changeToken): java.lang.String)
      .optionallyWith(
        tags.map(value =>
          value.map { item =>
            item.buildAwsValue()
          }.asJavaCollection
        )
      )(_.tags)
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.CreateWebAclRequest.ReadOnly =
    zio.aws.wafregional.model.CreateWebAclRequest.wrap(buildAwsValue())
}
object CreateWebAclRequest {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.CreateWebAclRequest
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.CreateWebAclRequest =
      zio.aws.wafregional.model.CreateWebAclRequest(
        name,
        metricName,
        defaultAction.asEditable,
        changeToken,
        tags.map(value =>
          value.map { item =>
            item.asEditable
          }
        )
      )
    def name: ResourceName
    def metricName: MetricName
    def defaultAction: zio.aws.wafregional.model.WafAction.ReadOnly
    def changeToken: ChangeToken
    def tags: Optional[List[zio.aws.wafregional.model.Tag.ReadOnly]]
    def getName: ZIO[Any, Nothing, ResourceName] = ZIO.succeed(name)
    def getMetricName: ZIO[Any, Nothing, MetricName] = ZIO.succeed(metricName)
    def getDefaultAction
        : ZIO[Any, Nothing, zio.aws.wafregional.model.WafAction.ReadOnly] =
      ZIO.succeed(defaultAction)
    def getChangeToken: ZIO[Any, Nothing, ChangeToken] =
      ZIO.succeed(changeToken)
    def getTags
        : ZIO[Any, AwsError, List[zio.aws.wafregional.model.Tag.ReadOnly]] =
      AwsError.unwrapOptionField("tags", tags)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclRequest
  ) extends zio.aws.wafregional.model.CreateWebAclRequest.ReadOnly {
    override val name: ResourceName =
      zio.aws.wafregional.model.primitives.ResourceName(impl.name())
    override val metricName: MetricName =
      zio.aws.wafregional.model.primitives.MetricName(impl.metricName())
    override val defaultAction: zio.aws.wafregional.model.WafAction.ReadOnly =
      zio.aws.wafregional.model.WafAction.wrap(impl.defaultAction())
    override val changeToken: ChangeToken =
      zio.aws.wafregional.model.primitives.ChangeToken(impl.changeToken())
    override val tags: Optional[List[zio.aws.wafregional.model.Tag.ReadOnly]] =
      zio.aws.core.internal
        .optionalFromNullable(impl.tags())
        .map(value =>
          value.asScala.map { item =>
            zio.aws.wafregional.model.Tag.wrap(item)
          }.toList
        )
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.CreateWebAclRequest
  ): zio.aws.wafregional.model.CreateWebAclRequest.ReadOnly = new Wrapper(impl)
}
