package zio.aws.wafregional.model
import zio.ZIO
import zio.aws.core.BuilderHelper
import scala.jdk.CollectionConverters.*
final case class ByteMatchSetUpdate(
    action: zio.aws.wafregional.model.ChangeAction,
    byteMatchTuple: zio.aws.wafregional.model.ByteMatchTuple
) {
  def buildAwsValue()
      : software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate = {
    import ByteMatchSetUpdate.zioAwsBuilderHelper.BuilderOps
    software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
      .builder()
      .action(action.unwrap)
      .byteMatchTuple(byteMatchTuple.buildAwsValue())
      .build()
  }
  def asReadOnly: zio.aws.wafregional.model.ByteMatchSetUpdate.ReadOnly =
    zio.aws.wafregional.model.ByteMatchSetUpdate.wrap(buildAwsValue())
}
object ByteMatchSetUpdate {
  private lazy val zioAwsBuilderHelper: BuilderHelper[
    software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
  ] = BuilderHelper.apply
  trait ReadOnly {
    def asEditable: zio.aws.wafregional.model.ByteMatchSetUpdate =
      zio.aws.wafregional.model
        .ByteMatchSetUpdate(action, byteMatchTuple.asEditable)
    def action: zio.aws.wafregional.model.ChangeAction
    def byteMatchTuple: zio.aws.wafregional.model.ByteMatchTuple.ReadOnly
    def getAction: ZIO[Any, Nothing, zio.aws.wafregional.model.ChangeAction] =
      ZIO.succeed(action)
    def getByteMatchTuple
        : ZIO[Any, Nothing, zio.aws.wafregional.model.ByteMatchTuple.ReadOnly] =
      ZIO.succeed(byteMatchTuple)
  }
  private final class Wrapper(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
  ) extends zio.aws.wafregional.model.ByteMatchSetUpdate.ReadOnly {
    override val action: zio.aws.wafregional.model.ChangeAction =
      zio.aws.wafregional.model.ChangeAction.wrap(impl.action())
    override val byteMatchTuple
        : zio.aws.wafregional.model.ByteMatchTuple.ReadOnly =
      zio.aws.wafregional.model.ByteMatchTuple.wrap(impl.byteMatchTuple())
  }
  def wrap(
      impl: software.amazon.awssdk.services.waf.model.ByteMatchSetUpdate
  ): zio.aws.wafregional.model.ByteMatchSetUpdate.ReadOnly = new Wrapper(impl)
}
